/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rooms;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import technology.rocketjump.undermount.entities.dictionaries.furniture.FurnitureTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.rendering.HexColors;
import technology.rocketjump.undermount.rooms.RoomType;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.i18n.I18nUpdatable;

@Singleton
public class RoomTypeDictionary
implements Telegraph,
I18nUpdatable {
    private final I18nTranslator translator;
    private Map<String, RoomType> byName = new HashMap<String, RoomType>();
    private Map<String, RoomType> byTranslatedName = new TreeMap<String, RoomType>();
    public static final RoomType VIRTUAL_PLACING_ROOM = new RoomType();

    @Inject
    public RoomTypeDictionary(MessageDispatcher messageDispatcher, I18nTranslator i18nTranslator, FurnitureTypeDictionary furnitureTypeDictionary) throws IOException {
        this(Gdx.files.internal("assets/definitions/roomTypes.json"), messageDispatcher, i18nTranslator, furnitureTypeDictionary);
    }

    public RoomTypeDictionary(FileHandle jsonFile, MessageDispatcher messageDispatcher, I18nTranslator i18nTranslator, FurnitureTypeDictionary furnitureTypeDictionary) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        this.translator = i18nTranslator;
        List roomTypes = (List)objectMapper.readValue(jsonFile.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, RoomType.class));
        for (RoomType roomType : roomTypes) {
            this.byName.put(roomType.getRoomName(), roomType);
            for (String furnitureName : roomType.getFurnitureNames()) {
                FurnitureType applicableFurnitureType = furnitureTypeDictionary.getByName(furnitureName);
                if (applicableFurnitureType == null) {
                    System.err.println("Could not find furniture type by name " + furnitureName + " for room " + roomType.getRoomName());
                    continue;
                }
                applicableFurnitureType.getValidRoomTypes().add(roomType);
            }
        }
        this.onLanguageUpdated();
        messageDispatcher.addListener(this, 291);
    }

    public RoomType getByName(String name) {
        return this.byName.get(name);
    }

    public Collection<RoomType> getAll() {
        return this.byTranslatedName.values();
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 291: {
                this.onLanguageUpdated();
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    @Override
    public void onLanguageUpdated() {
        this.byTranslatedName.clear();
        for (RoomType roomType : this.byName.values()) {
            roomType.setI18nValue(this.translator.getTranslatedString(roomType.getI18nKey()));
            this.byTranslatedName.put(roomType.getI18nValue(), roomType);
        }
    }

    static {
        VIRTUAL_PLACING_ROOM.setRoomName("VIRTUAL_PLACING_ROOM");
        VIRTUAL_PLACING_ROOM.setColor(HexColors.get("#ffff66AA"));
        VIRTUAL_PLACING_ROOM.setI18nKey("ROOMS.VIRTUAL_ROOM");
        VIRTUAL_PLACING_ROOM.setIconName("help");
        VIRTUAL_PLACING_ROOM.setEdgeName("straight");
    }
}

